<?php
/**
 * Webhook для Telegram Bot API.
 * Принимает обновления (сообщения и callback_query от inline-кнопок).
 * Обрабатывает нажатия кнопок: сохраняет выбранный контент (page1, page2, page3) по session_id.
 *
 * Установка webhook (вызвать один раз):
 *   https://api.telegram.org/bot<BOT_TOKEN>/setWebhook?url=https://yourdomain.com/p1/webhook.php
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/storage_helper.php';

$body = file_get_contents('php://input');
if ($body === '') {
    http_response_code(200);
    exit;
}

$data = json_decode($body, true);
if (!is_array($data)) {
    http_response_code(200);
    exit;
}

// --- Обработка callback_query (нажатие inline-кнопки) ---

$callbackQuery = $data['callback_query'] ?? null;
if ($callbackQuery) {
    $callbackData = $callbackQuery['data'] ?? '';
    $callbackId = $callbackQuery['id'] ?? '';

    // callback_data в формате "page1|session_id" или "page2|session_id", "page3|session_id"
    $parts = explode('|', $callbackData, 2);
    $page = $parts[0] ?? '';
    $sessionId = $parts[1] ?? '';

    if (in_array($page, ['page1', 'page2', 'page3'], true) && $sessionId !== '') {
        $state = loadState();
        $state[$sessionId] = $page;
        saveState($state);

        // Ответить Telegram, чтобы убрать "часики" на кнопке
        $answerUrl = 'https://api.telegram.org/bot' . BOT_TOKEN . '/answerCallbackQuery';
        $ch = curl_init($answerUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, ['callback_query_id' => $callbackId]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);
    }
}

// Всегда возвращаем 200, чтобы Telegram не повторял запрос
http_response_code(200);
