<?php
/**
 * Чтение/запись состояния сессий (выбранный контент page1, page2, page3).
 */

require_once __DIR__ . '/config.php';

function loadState(): array {
    $file = STORAGE_FILE;
    if (!is_file($file)) {
        return [];
    }
    $json = file_get_contents($file);
    $data = @json_decode($json, true);
    return is_array($data) ? $data : [];
}

function saveState(array $state): void {
    $dir = dirname(STORAGE_FILE);
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
    file_put_contents(STORAGE_FILE, json_encode($state, JSON_PRETTY_PRINT));
}
